/*
 * Decompiled with CFR 0.152.
 */
package filenet.ws.api;

import filenet.vw.base.logging.Logger;
import filenet.ws.api.WSDefinition;
import filenet.ws.api.WSMIMEPart;
import filenet.ws.api.WSMessage;
import filenet.ws.api.WSSoapHeader;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.wsdl.extensions.http.HTTPUrlEncoded;
import javax.wsdl.extensions.http.HTTPUrlReplacement;
import javax.wsdl.extensions.mime.MIMEContent;
import javax.wsdl.extensions.mime.MIMEMimeXml;
import javax.wsdl.extensions.mime.MIMEMultipartRelated;
import javax.wsdl.extensions.mime.MIMEPart;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPHeader;
import javax.wsdl.extensions.soap.SOAPHeaderFault;

public abstract class WSBindingInOutBase {
    protected static Logger logger = Logger.getLogger("filenet.ws.api");
    private static String m_className = "WSBindingInOutBase";
    protected WSDefinition m_definition = null;
    protected SOAPBody m_soapBody = null;
    protected WSSoapHeader[] m_soapHeaders = null;
    protected SOAPHeaderFault[] m_soapHeaderFaults = null;
    protected WSMessage m_soapHeaderMessage = null;
    protected HTTPUrlEncoded m_httpUrlEncoded = null;
    protected HTTPUrlReplacement m_httpUrlReplacement = null;
    protected WSMIMEPart[] m_mimeParts = null;
    protected Object[] m_mimeElements = null;
    private Object[] m_otherElements = null;

    public static String _get_FILE_DATE() {
        return "$Date:   10 Sep 2008 10:00:24  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   ysoong  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.8  $";
    }

    public abstract String getName();

    public abstract String getDisplayName();

    public abstract String toString();

    void releaseReferences() {
        block12: {
            try {
                int i;
                this.m_definition = null;
                this.m_soapBody = null;
                this.m_soapHeaderMessage = null;
                this.m_httpUrlEncoded = null;
                this.m_httpUrlReplacement = null;
                if (this.m_soapHeaders != null) {
                    WSSoapHeader soapHeader = null;
                    WSSoapHeader[] soapHeaders = this.m_soapHeaders;
                    this.m_soapHeaders = null;
                    for (i = 0; i < soapHeaders.length; ++i) {
                        if (soapHeaders[i] == null) continue;
                        soapHeader = soapHeaders[i];
                        soapHeaders[i] = null;
                        soapHeader.releaseReferences();
                        soapHeader = null;
                    }
                    soapHeaders = null;
                }
                if (this.m_soapHeaderFaults != null) {
                    SOAPHeaderFault[] soapHeaderFaults = this.m_soapHeaderFaults;
                    this.m_soapHeaderFaults = null;
                    for (int i2 = 0; i2 < soapHeaderFaults.length; ++i2) {
                        if (soapHeaderFaults[i2] == null) continue;
                        soapHeaderFaults[i2] = null;
                    }
                    soapHeaderFaults = null;
                }
                if (this.m_mimeParts != null) {
                    WSMIMEPart[] mimeParts = this.m_mimeParts;
                    this.m_mimeParts = null;
                    WSMIMEPart mimePart = null;
                    for (i = 0; i < mimeParts.length; ++i) {
                        if (mimeParts[i] == null) continue;
                        mimePart = mimeParts[i];
                        mimeParts[i] = null;
                        mimePart.releaseReferences();
                        mimePart = null;
                    }
                    mimeParts = null;
                }
                if (this.m_mimeElements != null) {
                    Object[] mimeElements = this.m_mimeElements;
                    this.m_mimeElements = null;
                    for (int i3 = 0; i3 < mimeElements.length; ++i3) {
                        mimeElements[i3] = null;
                    }
                    mimeElements = null;
                }
                if (this.m_otherElements != null) {
                    Object[] otherElements = this.m_otherElements;
                    this.m_otherElements = null;
                    for (int i4 = 0; i4 < otherElements.length; ++i4) {
                        otherElements[i4] = null;
                    }
                    otherElements = null;
                }
            }
            catch (Exception ex) {
                if (!logger.isFinest()) break block12;
                logger.throwing(m_className, "releaseReferences", ex);
            }
        }
    }

    protected void initExtensiveElements(List l) {
        if (l != null && l.size() > 0) {
            Vector<WSSoapHeader> soapHeaders = new Vector<WSSoapHeader>();
            Vector mimeElementVector = new Vector();
            Vector otherElementVector = new Vector();
            Iterator it = l.iterator();
            if (it != null) {
                while (it.hasNext()) {
                    Object obj = it.next();
                    if (obj == null) continue;
                    if (obj instanceof SOAPBody) {
                        this.m_soapBody = (SOAPBody)obj;
                        continue;
                    }
                    if (obj instanceof SOAPHeader) {
                        soapHeaders.add(new WSSoapHeader(this.m_definition, (SOAPHeader)obj));
                        continue;
                    }
                    if (obj instanceof MIMEContent) {
                        mimeElementVector.add(obj);
                        continue;
                    }
                    if (obj instanceof MIMEMimeXml) {
                        mimeElementVector.add(obj);
                        continue;
                    }
                    if (obj instanceof MIMEMultipartRelated) {
                        MIMEMultipartRelated multiPart = (MIMEMultipartRelated)obj;
                        List list = multiPart.getMIMEParts();
                        if (list == null || list.size() <= 0) continue;
                        this.m_mimeParts = new WSMIMEPart[list.size()];
                        Iterator iterator = list.iterator();
                        int i = 0;
                        if (iterator == null) continue;
                        Object object = null;
                        while (iterator.hasNext()) {
                            object = iterator.next();
                            if (!(object instanceof MIMEPart)) continue;
                            this.m_mimeParts[i++] = new WSMIMEPart(this.m_definition, object);
                        }
                        continue;
                    }
                    if (obj instanceof HTTPUrlEncoded) {
                        this.m_httpUrlEncoded = (HTTPUrlEncoded)obj;
                        continue;
                    }
                    if (obj instanceof HTTPUrlReplacement) {
                        this.m_httpUrlReplacement = (HTTPUrlReplacement)obj;
                        continue;
                    }
                    otherElementVector.add(obj);
                }
                if (soapHeaders != null && soapHeaders.size() > 0) {
                    this.m_soapHeaders = new WSSoapHeader[soapHeaders.size()];
                    soapHeaders.toArray(this.m_soapHeaders);
                    soapHeaders.removeAllElements();
                }
                if (mimeElementVector != null && mimeElementVector.size() > 0) {
                    this.m_mimeElements = new Object[mimeElementVector.size()];
                    mimeElementVector.toArray(this.m_mimeElements);
                    mimeElementVector.removeAllElements();
                }
                if (otherElementVector != null && otherElementVector.size() > 0) {
                    this.m_otherElements = new Object[otherElementVector.size()];
                    otherElementVector.toArray(this.m_otherElements);
                    otherElementVector.removeAllElements();
                }
            }
        }
    }

    public Object[] getMimeElements() {
        return this.m_mimeElements;
    }

    public WSMIMEPart[] getMimeParts() {
        return this.m_mimeParts;
    }

    public Object[] getOtherElements() {
        return this.m_otherElements;
    }

    public SOAPBody getSoapBody() {
        return this.m_soapBody;
    }

    public String[] getSoapBodyEncodingStyles() {
        List list;
        String[] encodingStyles = null;
        if (encodingStyles == null && this.m_soapBody != null && (list = this.m_soapBody.getEncodingStyles()) != null && list.size() > 0) {
            encodingStyles = new String[list.size()];
            Object obj = null;
            for (int i = 0; i < list.size(); ++i) {
                obj = list.get(i);
                if (obj == null || !(obj instanceof String)) continue;
                encodingStyles[i] = obj;
            }
        }
        return encodingStyles;
    }

    public String getSoapBodyNamespace() {
        if (this.m_soapBody != null) {
            return this.m_soapBody.getNamespaceURI();
        }
        return null;
    }

    public String[] getSoapBodyParts() {
        List list;
        String[] parts = null;
        if (parts == null && this.m_soapBody != null && (list = this.m_soapBody.getParts()) != null && list.size() > 0) {
            parts = new String[list.size()];
            Object obj = null;
            for (int i = 0; i < list.size(); ++i) {
                obj = list.get(i);
                if (obj == null || !(obj instanceof String)) continue;
                parts[i] = obj;
            }
        }
        return parts;
    }

    public String getSoapBodyUse() {
        if (this.m_soapBody != null) {
            return this.m_soapBody.getUse();
        }
        return null;
    }

    public WSSoapHeader[] getSoapHeaders() {
        return this.m_soapHeaders;
    }

    public boolean isHTTPUrlEncoded() {
        return this.m_httpUrlEncoded != null;
    }

    public boolean isHTTPUrlReplacement() {
        return this.m_httpUrlReplacement != null;
    }
}

